/***************************************************************************
*
* Copyright 2010, 2011 BMW Car IT GmbH
* Copyright (C) 2011 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
*
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*        http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
****************************************************************************/

#ifndef _WAYLANDGAL2DRENDERER_H_
#define _WAYLANDGAL2DRENDERER_H_

#include "BaseRenderer.h"
#include "LayerList.h"
#include "GraphicSystems/Gal2dGraphicSystem.h"
#include "WindowSystems/WaylandGal2dWindowSystem.h"

class ITextureBinder;

class WaylandGal2dRenderer : public BaseRenderer
{
public:
    WaylandGal2dRenderer(ICommandExecutor& executor, Configuration& config);

    // from PluginBase
    virtual t_ilm_const_string pluginGetName() const;

    bool start(int, int, const char*, int maxIterationDurationInMS);
    void stop();
    void doScreenShot(std::string fileToSave, uint screen_id);
    void doScreenShotOfLayer(std::string fileToSave, uint id);
    void doScreenShotOfSurface(std::string fileToSave, uint id, uint layer_id);
    uint getNumberOfHardwareLayers(uint screenID);
    uint* getScreenResolution(uint screenID);
    uint* getScreenIDs(uint* length);
    void signalWindowSystemRedraw();
    void forceCompositionWindowSystem();
    void destroyClientBufferShm(Surface * ilm_surface);
    virtual bool setOptimizationMode(OptimizationType id, OptimizationModeType mode);
    virtual bool getOptimizationMode(OptimizationType id, OptimizationModeType *mode);
    bool isSurfaceDirty(unsigned int surfID);
    bool isScreenFrozen(unsigned int screenID);
    virtual bool setGamma(unsigned int screenID, double value);
    virtual bool setCSC(unsigned int screenID, ilmCSCProperties* pclrprop);
    bool createVncbuffer(int displayID,int bpp,void **pp_vncsurfptr,void **pp_buffaddr);
    bool dumpFramebuffertovncsurf(int screenID);
    bool processVnctouchevent(int screenID,int x,int y,int down);
    bool processVncmouseevent(int screenID,int x,int y,int buttonmask);
    bool processVnckeyboardevent(int screenID,unsigned int keycode, int down);
    bool destroyVncbuffer(int screenID,void *p_vncsurfptr);

    // from PluginBase
    virtual int getIterationCounter();
    virtual InputManager* getInputManager(char *pSeatName) const;
    virtual bool getSupportedSeats(ilmInputDevice bitmask,
                           t_ilm_string ** pSeatArray,
                           unsigned int *pSizeSeatArray) const;
    virtual bool SetDisplayState(unsigned int screenId, ilmScreenState screenState) const;
    virtual bool GetDisplayState(unsigned int screenId, ilmScreenState *screenState) const;
    virtual bool SetDisplayAlpha(unsigned int screenId, unsigned int alphaValue) const;
    virtual bool GetDisplayAlpha(unsigned int screenId, unsigned int *alphaValue) const;
    float  getScreenFPS(uint screenID);
protected:
    WaylandGal2dWindowSystem* m_pWindowSystem;
    Gal2dGraphicSystem* m_pGraphicSystem;
    uint m_width;
    uint m_height;
    ITextureBinder* m_binder;
};

#endif /* _WAYLANDGAL2DRENDERER_H_*/
